/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import technology.rocketjump.undermount.entities.components.AttachedLightSourceComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.floor.FloorOverlap;
import technology.rocketjump.undermount.rendering.HexColors;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.RenderingOptions;
import technology.rocketjump.undermount.rendering.RoomRenderer;
import technology.rocketjump.undermount.rendering.TerrainRenderer;
import technology.rocketjump.undermount.rendering.custom_libgdx.AlphaMaskSpriteBatch;
import technology.rocketjump.undermount.rendering.custom_libgdx.VertexColorSpriteBatch;
import technology.rocketjump.undermount.rendering.entities.EntityRenderer;
import technology.rocketjump.undermount.rendering.lighting.LightProcessor;
import technology.rocketjump.undermount.rendering.lighting.PointLight;
import technology.rocketjump.undermount.rooms.RoomTypeDictionary;
import technology.rocketjump.undermount.rooms.constructions.Construction;
import technology.rocketjump.undermount.sprites.MasksSpriteCache;
import technology.rocketjump.undermount.sprites.TerrainSpriteCache;

public class WorldRenderer {
    public static final float ONE_UNIT = 1.0f;
    private final MasksSpriteCache masksSpriteCache;
    private final RenderingOptions renderingOptions;
    private final TerrainRenderer terrainRenderer;
    private final EntityRenderer entityRenderer;
    private final SpriteBatch basicSpriteBatch = new SpriteBatch();
    private final VertexColorSpriteBatch vertexColorSpriteBatch = new VertexColorSpriteBatch();
    private final AlphaMaskSpriteBatch alphaMaskSpriteBatch = new AlphaMaskSpriteBatch();
    private final PriorityQueue<Entity> entitiesToRender = new PriorityQueue<Entity>(new Entity.YDepthEntityComparator());
    private final Set<Long> entitiesRenderedThisFrame = new HashSet<Long>();
    private final Map<Long, Construction> constructionsToRender = new TreeMap<Long, Construction>();
    private final RoomRenderer roomRenderer;
    private final LightProcessor lightProcessor;
    private static final Color CONSTRUCTION_COLOR = HexColors.get("#EEEEEE99");

    @Inject
    public WorldRenderer(MasksSpriteCache masksSpriteCache, RenderingOptions renderingOptions, TerrainRenderer terrainRenderer, EntityRenderer entityRenderer, RoomRenderer roomRenderer, LightProcessor lightProcessor) {
        this.masksSpriteCache = masksSpriteCache;
        this.renderingOptions = renderingOptions;
        this.terrainRenderer = terrainRenderer;
        this.entityRenderer = entityRenderer;
        this.roomRenderer = roomRenderer;
        this.lightProcessor = lightProcessor;
    }

    public void renderWorld(TiledMap tiledMap, OrthographicCamera camera, TerrainSpriteCache spriteCache, RenderMode renderMode, List<PointLight> lightsToRenderThisFrame) {
        Construction construction;
        MapTile mapTile;
        int worldX;
        int worldY;
        Gdx.gl.glClearColor(0.4f, 0.4f, 0.4f, 1.0f);
        Gdx.gl.glClear(16384);
        this.entitiesToRender.clear();
        this.entitiesRenderedThisFrame.clear();
        this.constructionsToRender.clear();
        int minX = WorldRenderer.getMinX(camera);
        int maxX = WorldRenderer.getMaxX(camera, tiledMap);
        int minY = WorldRenderer.getMinY(camera);
        int maxY = WorldRenderer.getMaxY(camera, tiledMap);
        this.vertexColorSpriteBatch.setProjectionMatrix(camera.combined);
        this.vertexColorSpriteBatch.enableBlending();
        this.vertexColorSpriteBatch.begin();
        this.vertexColorSpriteBatch.setColor(Color.WHITE);
        for (worldY = maxY; worldY >= minY; --worldY) {
            for (worldX = minX; worldX <= maxX; ++worldX) {
                mapTile = tiledMap.getTile(worldX, worldY);
                if (mapTile == null) continue;
                this.terrainRenderer.render(mapTile, worldX, worldY, this.vertexColorSpriteBatch, spriteCache, renderMode);
                this.entitiesToRender.addAll(mapTile.getEntities());
                if (mapTile.hasDoorway()) {
                    this.entitiesToRender.add(mapTile.getDoorway().getFrameEntity());
                    this.entitiesToRender.add(mapTile.getDoorway().getDoorEntity());
                    this.entitiesToRender.addAll(mapTile.getDoorway().getWallCapEntities());
                }
                if ((construction = mapTile.getConstruction()) == null) continue;
                this.constructionsToRender.put(construction.getId(), construction);
            }
        }
        this.vertexColorSpriteBatch.end();
        for (worldY = minY; worldY >= minY - 4; --worldY) {
            for (worldX = minX; worldX <= maxX; ++worldX) {
                mapTile = tiledMap.getTile(worldX, worldY);
                if (mapTile == null) continue;
                this.entitiesToRender.addAll(mapTile.getEntities());
                construction = mapTile.getConstruction();
                if (construction == null) continue;
                this.constructionsToRender.put(construction.getId(), construction);
            }
        }
        if (this.renderingOptions.isFloorOverlapRenderingEnabled()) {
            this.alphaMaskSpriteBatch.setProjectionMatrix(camera.combined);
            this.alphaMaskSpriteBatch.begin();
            this.alphaMaskSpriteBatch.setColor(Color.WHITE);
            for (worldY = maxY; worldY >= minY; --worldY) {
                for (worldX = minX; worldX <= maxX; ++worldX) {
                    mapTile = tiledMap.getTile(worldX, worldY);
                    if (mapTile == null || !mapTile.hasFloor() || mapTile.getFloor().getOverlaps().size <= 0) continue;
                    for (FloorOverlap floorOverlap : mapTile.getFloor().getOverlaps()) {
                        Sprite overlapAlphaMask = this.masksSpriteCache.getMaskForOverlap(floorOverlap.getLayout(), mapTile.getSeed());
                        Sprite overlapSprite = spriteCache.getFloorSpriteForType(floorOverlap.getFloorType(), mapTile.getSeed());
                        if (renderMode.equals((Object)RenderMode.DIFFUSE)) {
                            this.alphaMaskSpriteBatch.draw(overlapSprite, overlapAlphaMask, worldX, worldY, 1.0f, 1.0f, floorOverlap.getVertexColors());
                            continue;
                        }
                        this.alphaMaskSpriteBatch.draw(overlapSprite, overlapAlphaMask, worldX, worldY, 1.0f, 1.0f);
                    }
                }
            }
            this.alphaMaskSpriteBatch.end();
        }
        this.basicSpriteBatch.setProjectionMatrix(camera.combined);
        this.basicSpriteBatch.enableBlending();
        this.basicSpriteBatch.begin();
        if (renderMode.equals((Object)RenderMode.DIFFUSE)) {
            for (worldY = maxY; worldY >= minY; --worldY) {
                for (worldX = minX; worldX <= maxX; ++worldX) {
                    mapTile = tiledMap.getTile(worldX, worldY);
                    if (mapTile == null || !mapTile.hasRoom() || mapTile.getRoomTile().getRoom().getRoomType().getRoomName().equals(RoomTypeDictionary.VIRTUAL_PLACING_ROOM.getRoomName())) continue;
                    this.roomRenderer.render(mapTile, this.basicSpriteBatch, spriteCache);
                }
            }
        }
        this.basicSpriteBatch.setColor(Color.WHITE);
        for (Construction construction2 : this.constructionsToRender.values()) {
            if (construction2.getEntity() == null) continue;
            this.entityRenderer.render(construction2.getEntity(), (Batch)this.basicSpriteBatch, renderMode, null, CONSTRUCTION_COLOR);
        }
        while (!this.entitiesToRender.isEmpty()) {
            AttachedLightSourceComponent attachedLightSourceComponent;
            Entity entity = this.entitiesToRender.poll();
            if (this.entitiesRenderedThisFrame.contains(entity.getId())) continue;
            this.entitiesRenderedThisFrame.add(entity.getId());
            this.entityRenderer.render(entity, (Batch)this.basicSpriteBatch, renderMode, null, null);
            if (lightsToRenderThisFrame == null || (attachedLightSourceComponent = entity.getComponent(AttachedLightSourceComponent.class)) == null || !attachedLightSourceComponent.isEnabled()) continue;
            lightsToRenderThisFrame.add(attachedLightSourceComponent.getLightForRendering(tiledMap, this.lightProcessor));
        }
        this.basicSpriteBatch.end();
    }

    public static int getMaxY(OrthographicCamera camera, TiledMap tiledMap) {
        int maxY = (int)Math.ceil(camera.frustum.planePoints[2].y);
        if ((maxY += 2) >= tiledMap.getHeight()) {
            maxY = tiledMap.getHeight() - 1;
        }
        return maxY;
    }

    public static int getMinY(OrthographicCamera camera) {
        int minY = (int)Math.floor(camera.frustum.planePoints[0].y);
        if (--minY < 0) {
            minY = 0;
        }
        return minY;
    }

    public static int getMaxX(OrthographicCamera camera, TiledMap tiledMap) {
        int maxX = (int)Math.ceil(camera.frustum.planePoints[2].x);
        if ((maxX += 2) >= tiledMap.getWidth()) {
            maxX = tiledMap.getWidth() - 1;
        }
        return maxX;
    }

    public static int getMinX(OrthographicCamera camera) {
        int minX = (int)Math.floor(camera.frustum.planePoints[0].x);
        if (--minX < 0) {
            minX = 0;
        }
        return minX;
    }
}

